//***************************************************************************//**
//EEPROM LIB v 1.0
//******************************************************************************/
#include "stm32f10x_gpio.h"
#include "stm32f10x_i2c.h"
#include "stm32f10x_rcc.h"

#include "i2c_soft.h"

#define EEPROM_HW_ADDRESS      0xA0   /* E0 = E1 = E2 = 0 */

void Delay_ms(uint32_t ms);

void I2C_Configuration(void)
	{
	i2c_init();
	i2c_stop();
	i2c_stop();
	i2c_stop();
	i2c_stop();
	}

void I2C_EE_ByteWrite(uint8_t val, uint16_t WriteAddr)
	{
	i2c_start();
	i2c_tx(EEPROM_HW_ADDRESS);
	i2c_tx((uint8_t)((WriteAddr & 0xFF00) >> 8));
	i2c_tx((uint8_t)(WriteAddr & 0x00FF));
	i2c_tx(val);
	i2c_stop();
    Delay_ms(5);	//delay between write and read...not less 4ms
	}

uint8_t I2C_EE_ByteRead(uint16_t ReadAddr)
	{
    uint8_t tmp;

	i2c_start();
	i2c_tx(EEPROM_HW_ADDRESS);
	i2c_tx((uint8_t)((ReadAddr & 0xFF00) >> 8));
	i2c_tx((uint8_t)(ReadAddr & 0x00FF));
	i2c_start();
	i2c_tx(EEPROM_HW_ADDRESS+1);
	tmp = i2c_rx(0);
	i2c_stop();
	
	return tmp;
    }

void Delay_ms(uint32_t ms)
	{
    volatile uint32_t nCount;
    RCC_ClocksTypeDef RCC_Clocks;
    RCC_GetClocksFreq (&RCC_Clocks);

    nCount=(RCC_Clocks.HCLK_Frequency/10000)*ms;
    for (; nCount!=0; nCount--);
	}






